<?php
/**
 * Settings Page Template.
 *
 * @var string $api_username
 * @var string $api_password
 *
 * @package Hello_Sajto
 */

?>

<div class="wrap">
<h1><?php esc_html_e( 'Helló Sajtó Settings', 'hello-sajto-for-news-sites' ); ?></h1>
	<form method="post" action="">
		<?php wp_nonce_field( 'hs_save_settings_nonce_action', 'hs_save_settings_nonce' ); ?>
		<table class="form-table">
			<tr>
				<th scope="row"><?php esc_html_e( 'API username', 'hello-sajto-for-news-sites' ); ?></th>
				<td><input type="text" name="hello_sajto_api_username" value="<?php echo esc_attr( $api_username ); ?>"
					class="regular-text" /></td>
			</tr>
			<tr>
				<th scope="row"><?php esc_html_e( 'API password', 'hello-sajto-for-news-sites' ); ?></th>
				<td><input type="password" name="hello_sajto_api_password" value="<?php echo esc_attr( $api_password ); ?>"
					class="regular-text" /></td>
			</tr>
			<tr>
				<th scope="row"><?php esc_html_e( 'Also imports tags', 'hello-sajto-for-news-sites' ); ?></th>
				<td><input type="checkbox" name="hello_sajto_import_tags" value="1" <?php checked( $import_tags, 1 ); ?> /></td>
			</tr>
		</table>
		<p class="submit">
			<input type="submit" class="button-primary" value="<?php esc_html_e( 'Save', 'hello-sajto-for-news-sites' ); ?>" />
		</p>
	</form>
</div>
