<?php
/**
 * Filter form template for press releases admin page.
 *
 * @var object $this Instance of the Hello_Sajto_Press_Releases_List_Table class.
 * @var string $keyword Search keyword.
 *
 * @package Hello_Sajto
 */

?>

<form method="get" action="" class="hs-press-releases-filter-form">
<input type="hidden" name="page" value="<?php echo esc_attr( $_GET['page'] ); ?>" />
<div class="alignleft actions">
<label for="filter-by-category" class="screen-reader-text"><?php esc_html_e( 'Filter by category', 'hello-sajto-for-news-sites' ); ?></label>
<select name="category" id="filter-by-category" class="postform">
<option value=""><?php esc_html_e( 'All Categories', 'hello-sajto-for-news-sites' ); ?></option>

<?php foreach ( $this->categories as $category ) : ?>
	<?php $selected = ( isset( $_GET['category'] ) && (int) $_GET['category'] === (int) $category['id'] ) ? ' selected="selected"' : ''; ?>
<option value="<?php echo esc_attr( $category['id'] ); ?>"<?php echo esc_attr( $selected ); ?>><?php echo esc_html( $category['name'] ); ?></option>
<?php endforeach; ?>

</select>
<input type="text" name="keyword" value="<?php echo esc_attr( $keyword ); ?>" placeholder="<?php echo esc_attr__( '...search', 'hello-sajto-for-news-sites' ); ?>" />

<?php submit_button( esc_html__( 'Filter', 'hello-sajto-for-news-sites' ), '', 'filter_action', false, array( 'id' => 'post-query-submit' ) ); ?>

</div>
</form>
