<?php
/**
 * Plugin Name: Helló Sajtó for News Sites
 * Plugin URI: https://hellosajto.hu/hello-sajto-wordpress-plugin/
 * Description: WP plugin for news sites to easily access press releases from the Helló Sajtó Press Release Distribution Service.
 * Version: 1.0.1
 * Author: Helló Sajtó Press Release Distribution Service
 * Author URI: https://hellosajto.hu
 * Text Domain: hello-sajto
 * Domain Path: /languages
 *
 * @package Hello_Sajto
 */

// Prevent direct access to the file.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Define plugin constants.
define( 'HELLO_SAJTO_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'HELLO_SAJTO_PLUGIN_FILE', __FILE__ );
define( 'HELLO_SAJTO_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
define( 'HELLO_SAJTO_MAX_ITEMS_TO_SELECT', 5 );

// Include necessary files.
require_once HELLO_SAJTO_PLUGIN_DIR . 'classes/class-hello-sajto-settings.php';
require_once HELLO_SAJTO_PLUGIN_DIR . 'classes/class-hello-sajto-press-releases.php';
require_once HELLO_SAJTO_PLUGIN_DIR . 'classes/class-hello-sajto-call-api.php';
require_once HELLO_SAJTO_PLUGIN_DIR . 'classes/class-hello-sajto-press-releases-list-table.php';
require_once HELLO_SAJTO_PLUGIN_DIR . 'classes/class-hello-sajto-import.php';
require_once HELLO_SAJTO_PLUGIN_DIR . 'classes/class-hello-sajto-ajax.php';
require_once HELLO_SAJTO_PLUGIN_DIR . 'classes/class-hello-sajto.php';

// Initialize the plugin.
( new Hello_Sajto() )::get_instance()->init();
