<?php
/**
 * Class Hello_Sajto
 *
 * @package Hello_Sajto
 */
class Hello_Sajto {

	/**
	 * Singleton instance.
	 *
	 * @var static
	 */
	private static $instance     = null;
	private const  ASSET_VERSION = '1.0.1';

	/**
	 * Singleton get function.
	 *
	 * @return Hello_Sajto|null
	 */
	public static function get_instance(): ?Hello_Sajto {
		if ( self::$instance ) {
			return self::$instance;
		}

		self::$instance = new self();

		return self::$instance;
	}

	/**
	 * Constructor to initialize the plugin.
	 */
	public function init() {
		if ( is_admin() ) {
			// Load plugin text domain for translations.
			add_action( 'plugins_loaded', array( __CLASS__, 'load_textdomain' ) );

			// Enqueue admin styles and scripts.
			add_action( 'admin_enqueue_scripts', array( __CLASS__, 'admin_enqueue_scripts' ) );

			// Register the settings page in the admin menu.
			add_action( 'admin_menu', array( 'Hello_Sajto_Settings', 'register_page' ) );

			// Add custom menu for the plugin.
			add_action( 'admin_menu', array( __CLASS__, 'custom_menu' ) );

			// Add a settings link to the plugin actions on the Plugins page.
			add_filter( 'plugin_action_links_' . plugin_basename( HELLO_SAJTO_PLUGIN_FILE ), array( 'Hello_Sajto_Settings', 'add_settings_link' ) );

			// Register the AJAX action for importing press releases.
			add_action( 'wp_ajax_hs_press_release_import', array( 'Hello_Sajto_Ajax', 'press_release_import' ) );

			// Add ThickBox support for the admin area.
			add_thickbox();
		}
	}

	/**
	 * Load plugin text domain for translations.
	 */
	public static function load_textdomain() {
		load_plugin_textdomain( 'hello-sajto-for-news-sites', false, dirname( plugin_basename( HELLO_SAJTO_PLUGIN_FILE ) ) . '/languages' );
	}

	/**
	 * Add CSS and JS files for the admin area.
	 */
	public static function admin_enqueue_scripts() {
		// Enqueue admin styles.
		wp_enqueue_style( 'hello-sajto-for-news-sites-admin-style', plugin_dir_url( HELLO_SAJTO_PLUGIN_FILE ) . 'assets/css/admin.css', array(), self::ASSET_VERSION );

		// Enqueue admin scripts.
		wp_enqueue_script( 'hello-sajto-script', HELLO_SAJTO_PLUGIN_URL . 'assets/js/script.js', array( 'jquery' ), self::ASSET_VERSION, true );

		// Add a JS variable to the script.
		wp_localize_script(
			'hello-sajto-script',
			'HsData',
			array(
				'ajaxUrl'          => array(
					'import' => admin_url( 'admin-ajax.php' ) . '?action=hs_press_release_import',
				),
				'message'          => array(
					'imported'           => sprintf( __( 'The press release has been successfully imported as a draft post. <a href="%s">Go to edit</a>', 'hello-sajto-for-news-sites' ), '/wp-admin/post.php?post=%POST_ID%&action=edit' ),
					'importedMultiple'   => sprintf( __( 'The press releases have been successfully imported as a draft post. <a href="%s">Go to edit</a>', 'hello-sajto-for-news-sites' ), '/wp-admin/edit.php' ),
					'selectLeastOneItem' => __( 'Please select at least one item to perform this action on.', 'hello-sajto-for-news-sites' ),
					'selectAnAction'     => __( 'Please select an action.', 'hello-sajto-for-news-sites' ),
					'maxItemsToSelect'   => sprintf( __( 'Up to %s items can be selected.', 'hello-sajto-for-news-sites' ), HELLO_SAJTO_MAX_ITEMS_TO_SELECT ),
				),
				'nonce'            => wp_create_nonce( 'hs_import_nonce' ),
				'maxItemsToSelect' => HELLO_SAJTO_MAX_ITEMS_TO_SELECT,
			)
		);
	}

	/**
	 * Add a settings link to the plugin actions on the Plugins page.
	 */
	public static function custom_menu() {
		add_menu_page(
			__( 'Helló Sajtó', 'hello-sajto-for-news-sites' ),
			__( 'Helló Sajtó', 'hello-sajto-for-news-sites' ),
			'edit_posts',
			'hello-sajto-press-releases',
			array( 'Hello_Sajto_Press_Releases', 'render_page' ),
			HELLO_SAJTO_PLUGIN_URL . 'assets/images/hello-sajto-bw-icon-32x32.png',
			100
		);

		remove_submenu_page( 'hello-sajto-press-releases', 'hello-sajto-press-releases' );

		add_submenu_page(
			'hello-sajto-press-releases',
			__( 'Press Releases', 'hello-sajto-for-news-sites' ),
			__( 'Press Releases', 'hello-sajto-for-news-sites' ),
			'edit_posts',
			'hello-sajto-press-releases',
			array( 'Hello_Sajto_Press_Releases', 'render_page' )
		);

		add_submenu_page(
			'hello-sajto-press-releases',
			__( 'Settings', 'hello-sajto-for-news-sites' ),
			__( 'Settings', 'hello-sajto-for-news-sites' ),
			'manage_options',
			'hello-sajto-settings',
			array( 'Hello_Sajto_Settings', 'render_page' )
		);
	}
}
