<?php
/**
 * Class Hello_Sajto_Settings
 *
 * @package Hello_Sajto
 */
class Hello_Sajto_Settings {
	/**
	 * Register the settings page in the admin menu.
	 */
	public static function register_page() {
		add_options_page(
			__( 'Helló Sajtó Settings', 'hello-sajto-for-news-sites' ),
			__( 'Helló Sajtó', 'hello-sajto-for-news-sites' ),
			'manage_options',
			'hello-sajto-settings',
			array( __CLASS__, 'render_page' )
		);
	}

	/**
	 * Render the settings page.
	 */
	public static function render_page() {
		if ( ! current_user_can( 'manage_options' ) ) {
			return;
		}

		// Save settings if the form is submitted.
		if ( isset( $_POST['hs_save_settings_nonce'] ) && wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['hs_save_settings_nonce'] ) ), 'hs_save_settings_nonce_action' ) ) {
			if ( isset( $_POST['hello_sajto_api_username'] ) ) {
				update_option( 'hello_sajto_api_username', sanitize_text_field( wp_unslash( $_POST['hello_sajto_api_username'] ) ), false );
			}

			if ( isset( $_POST['hello_sajto_api_password'] ) ) {
				update_option( 'hello_sajto_api_password', sanitize_text_field( wp_unslash( $_POST['hello_sajto_api_password'] ) ), false );
			}

			delete_option( 'hello_sajto_import_tags' );

			if ( isset( $_POST['hello_sajto_import_tags'] ) ) {
				update_option( 'hello_sajto_import_tags', 1, false );
			}

			echo '<div class="updated"><p>' . esc_html__( 'Settings saved.', 'hello-sajto-for-news-sites' ) . '</p></div>';
		}

		// Get current settings.
		$api_username = get_option( 'hello_sajto_api_username', '' );
		$api_password = get_option( 'hello_sajto_api_password', '' );
		$import_tags  = get_option( 'hello_sajto_import_tags', 0 );

		// Render the settings form.
		include_once HELLO_SAJTO_PLUGIN_DIR . 'templates/admin/settings.php';
	}

	/**
	 * Add a settings link to the plugin actions on the Plugins page.
	 *
	 * @param array $links Existing plugin action links.
	 * @return array Modified plugin action links.
	 */
	public static function add_settings_link( $links ) {
		$settings_link = '<a href="' . admin_url( 'options-general.php?page=hello-sajto-settings' ) . '">' . __( 'Settings', 'hello-sajto-for-news-sites' ) . '</a>';
		array_unshift( $links, $settings_link );

		return $links;
	}
}
