<?php
/**
 * Class Hello_Sajto_Ajax
 *
 * @package Hello_Sajto
 */
class Hello_Sajto_Ajax {
	/**
	 * Import function.
	 */
	public static function press_release_import() {
		try {
			// Check if the user has permission to edit posts.
			if ( ! current_user_can( 'edit_posts' ) ) {
				wp_send_json_error( __( 'You do not have sufficient permissions to access this page.', 'hello-sajto-for-news-sites' ), 403 );
			}

			// Check if the required POST parameters are set and valid.
			if ( ! isset( $_POST['post_ids'] )
			|| ! is_array( $_POST['post_ids'] )
			|| ! isset( $_POST['hs_import_nonce'] )
			|| ! wp_verify_nonce( $_POST['hs_import_nonce'], 'hs_import_nonce' ) ) {
				wp_send_json_error( __( 'Invalid request.', 'hello-sajto-for-news-sites' ), 400 );
			}

			// Validate post IDs.
			foreach ( $_POST['post_ids'] as $post_id ) {
				if ( ! is_numeric( $post_id ) || $post_id <= 0 ) {
					wp_send_json_error( __( 'Invalid post ID.', 'hello-sajto-for-news-sites' ), 400 );
				}
			}

			$imported_post_ids = array();

			// Loop through each post ID and import it.
			foreach ( $_POST['post_ids'] as $post_id ) {
				$imported_post_id = ( new Hello_Sajto_Import( (int) $post_id ) )->import();

				if ( ! is_numeric( $imported_post_id ) ) {
					wp_send_json_error( __( 'Failed to import', 'hello-sajto-for-news-sites' ), 400 );
				}

				$imported_post_ids[] = $imported_post_id;
			}

			// If all posts are imported successfully, send a success response.
			wp_send_json_success( $imported_post_ids );
			exit();
		} catch ( Exception $e ) {
			// If an exception occurs, send an error response.
			wp_send_json_error( __( 'Failed to import', 'hello-sajto-for-news-sites' ) . ': ' . esc_html( $e->getMessage() ), 400 );
			exit();
		}
	}
}
