(function ($) {
	const areYouSureModalId = 'hs-are-you-sure-to-import-modal';

	/**
	 * Init.
	 */
	function initImportButtons() {
		const importButtons = $('.hs-import-button');

		importButtons.each(function () {
			const button = $(this);
			button.on('click', function (e) {
				e.preventDefault();

				// Open the Thickbox modal programmatically.
				openThickboxModal(400, 200, areYouSureModalId);

				$('.hs-import-yes').on('click', function () {
					const postIds = [button.data('post-id')];
					doImport(postIds); // Call the doImport function with the form element.
				});
				$('.hs-import-no').on('click', function () {
					tb_remove(); // Close the Thickbox modal.
				});
			});
		});
	}

	/**
	 * Perform the import action.
	 *
	 * @param button
	 */
	function doImport(postIds) {
		const actionUrl = HsData.ajaxUrl.import;

		$('#hs-error').hide();
		$('#hs-success').hide();
		$('#TB_ajaxContent').html($('#hs-working-modal').html());

		$.ajax({
			url: actionUrl,
			type: 'POST',
			data: {
				post_ids: postIds,
				hs_import_nonce: HsData.nonce
			},
			dataType: "json",
			success: function (response) {
				if (response.success) {
					let successPostIds = response.data;
					let successMessage = (successPostIds.length > 1)
						? HsData.message.importedMultiple
						: HsData.message.imported.replace('%POST_ID%', successPostIds[0]);

					$('#hs-success').show().find('p').html(successMessage);
				} else {
					$('#hs-error').show().find('p').text(response.data);
				}

				tb_remove();
				scrollTo(0);
			},
			error: function (xhr, status, error) {
				let errorMessage = xhr.responseJSON && xhr.responseJSON.data ? xhr.responseJSON.data : error;

				$('#hs-error').show().find('p').text(errorMessage);
				tb_remove();
				scrollTo(0);
			}
		});
	}

	/**
	 * Open the Thickbox modal.
	 *
	 * @param number width
	 * @param number height
	 * @param string contentId
	 */
	function openThickboxModal(width, height, contentId) {
		tb_remove();

		tb_show(
			'', // Title (empty for now)
			`#TB_inline?height=${height}&width=${width}`
		);

		$('#TB_ajaxContent').html(
			$('#' + contentId).html()
		);
	}

	/*
	 * Scroll to a specific position.
	 *
	 * @param number pos
	 */
	function scrollTo(pos) {
		$('html, body').animate({
			scrollTop: pos
		}, 250);
	}

	/**
	 * Initialize bulk action apply buttons.
	 */
	function initBulkActionApplyButtons() {
		// If not import page.
		if (!window.location.href.includes('page=hello-sajto-press-releases')) {
			return;
		}

		const button = $('#doaction');
		const selectElem = button.prev('select');
		const maxItems = parseInt(HsData.maxItemsToSelect);

		button.on('click', function (e) {
			e.preventDefault();
			const selectedAction = selectElem.val();

			if (selectedAction === '-1') {
				alert(HsData.message.selectAnAction);
				return;
			}

			const selectedItems = [];

			$('input[name="bulk-select[]"]:checked').each(function () {
				selectedItems.push($(this).val());
			});

			if (selectedItems.length === 0) {
				alert(HsData.message.selectLeastOneItem);
				return;
			}

			if (selectedItems.length > maxItems) {
				alert(HsData.message.maxItemsToSelect);
				return;
			}

			// Open the Thickbox modal.
			openThickboxModal(400, 200, areYouSureModalId);

			$('.hs-import-yes').on('click', function () {
				doImport(selectedItems); // Call the doImport function with the form element.
			});
			$('.hs-import-no').on('click', function () {
				tb_remove(); // Close the Thickbox modal.
			});

			// Reset bulk select checkboxes and select element.
			$('input[name="bulk-select[]"]').prop('checked', false);
			selectElem.val('-1');
		});
	}

	initImportButtons();
	initBulkActionApplyButtons();
})(jQuery);
